/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWException;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class VWWorkBasketsTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    protected static final int COL_NAME = 0;
    private VWSessionInfo m_sessionInfo = null;
    private VWRoleDefinition m_roleDef = null;
    private ArrayList<VWWorkBasketDefinition> m_selectedItems = null;
    private boolean m_bIsModified = false;

    public VWWorkBasketsTableModel(VWDataDictionary dataDictionary) {
        try {
            this.m_sessionInfo = dataDictionary.getSessionInfo();
            this.m_selectedItems = new ArrayList();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWWorkBasketDefinition.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_selectedItems.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (workBasketDef == null) break;
                    return workBasketDef;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    public void reinitialize(VWDataDictionary dataDictionary) {
        this.setRoleDefinition(this.m_roleDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setRoleDefinition(VWRoleDefinition roleDefinition) {
        try {
            try {
                VWWorkBasketDefinition[] workBasketDefs;
                this.m_roleDef = roleDefinition;
                this.m_selectedItems = new ArrayList();
                if (this.m_roleDef != null && (workBasketDefs = this.m_roleDef.getWorkBasketDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < workBasketDefs.length; ++nIndex) {
                        this.m_selectedItems.add(workBasketDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void addNewWorkBasket(VWWorkBasketDefinition workBasketDef) throws VWException {
        if (this.m_roleDef == null) {
            return;
        }
        this.m_selectedItems.add(workBasketDef);
        VWWorkBasketDefinition[] selectedWorkBasketDefs = null;
        if (this.m_selectedItems.size() > 0) {
            selectedWorkBasketDefs = this.m_selectedItems.toArray(new VWWorkBasketDefinition[0]);
        }
        this.m_roleDef.setWorkBasketDefinitions(selectedWorkBasketDefs);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void deleteInbasketAtIndex(int nRowIndex) {
        try {
            VWWorkBasketDefinition workBasketDef = this.getRowItemAt(nRowIndex);
            this.m_selectedItems.remove(workBasketDef);
            if (this.m_selectedItems.size() > 0) {
                VWWorkBasketDefinition[] selectedWorkBasketDefs = this.m_selectedItems.toArray(new VWWorkBasketDefinition[0]);
                this.m_roleDef.setWorkBasketDefinitions(selectedWorkBasketDefs);
            } else {
                this.m_roleDef.setWorkBasketDefinitions(null);
            }
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void swap(int index1, int index2) {
        if (index1 > this.getRowCount() || index2 > this.getRowCount() || index1 < 0 || index2 < 0) {
            return;
        }
        try {
            VWWorkBasketDefinition item1 = this.m_selectedItems.remove(index1);
            this.m_selectedItems.add(index2, item1);
            VWWorkBasketDefinition[] selectedWorkBasketDefs = this.m_selectedItems.toArray(new VWWorkBasketDefinition[0]);
            this.m_roleDef.setWorkBasketDefinitions(selectedWorkBasketDefs);
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(Math.min(index1, index2), Math.max(index1, index2));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        this.m_selectedItems = null;
        this.m_sessionInfo = null;
        this.m_roleDef = null;
    }

    private VWWorkBasketDefinition getRowItemAt(int nRowIndex) {
        if (this.m_selectedItems == null || nRowIndex < 0 || nRowIndex > this.m_selectedItems.size()) {
            return null;
        }
        if (nRowIndex < this.m_selectedItems.size()) {
            return this.m_selectedItems.get(nRowIndex);
        }
        return null;
    }
}

